//
// Illustrator CS Import
// Martin Wengenmayer modified 20050202 Adrian Ward
// 
// Illustrator 8 UI Import for ver.5,6,7,8 AI file
// 
// v.20070324 - required version 3.5+
//
// Modified 20050614 Hiroto Tsubaki
// Modified 20050615 Hiroto Tsubaki
// Modified 20051108 Hiroto Tsubaki - added UI
// Modified 20060111 Hiroto Tsubaki - added 'make center'
// Modified 20061123 Hiroto Tsubaki - use selector.
//
// 20070324 fixed bugs.
// 20070420 fixed bugs. :(

var scaleLayerName = 'scale';

function buildUI(tool) {
    tool.addParameterSeparator("Illustrator 8 UI Importer");
    
    tool.addParameterSelector("base plane",["x","y","z"],true,true);
    tool.addParameterFloat("scale",0.01,0.01,1.00,true,true);
    tool.addParameterBool("auto scale",0,0,1,true,true);
    tool.addParameterBool("make center",0,0,1,true,true);
    
    tool.addParameterButton("Import","OK","importAI");
}

function setValueForPlane(basePlane, vector, v1, v2) { 
    
    if (basePlane == '0') { 
            vector.y = v1;
            vector.z = -v2;
    } else if (basePlane == '1') {
            vector.x = v1;
            vector.z = v2;
    } else if (basePlane == '2') {
            vector.x = v1;
            vector.y = -v2;
     }
    
    return vector;
}

function importAI(tool) {
    var doc = tool.document();
    
    var basePlane = tool.getParameter("base plane");
    var scale = tool.getParameter("scale");
    var autoscale = tool.getParameter("auto scale");
    var makeCenter = tool.getParameter("make center");
    var regExp = /\((.+)\) Ln/;
    
    var path = OS.runOpenPanel("ai");
    if (path == null) {
        print("Cancel");
        return;
    }
    
    var file = new File(path);
    file.open(READ_MODE);
    if (file.isOpen() == false) {
        print("file not open");
        return;
    }
    
    print("---- Illustrator 8 UI Importer ----");
    
    var splineobj;
    var spline;
    
    var line;
    var to            = new Vec3D(0,0,0);
    var cont1       = new Vec3D(0,0,0);
    var cont2       = new Vec3D(0,0,0);
    
    var move = new Vec3D(0,0,0);
    
    var complete    = 0;
    var nullcount   = 0;
    var hitcount    = 0;
    var linecount = 0;
    
    line = file.readln();
    
    if (autoscale) {
        var aminX = undefined;
        var aminZ = undefined;
        var amaxX = undefined;
        var amaxZ = undefined;
        var automode = false;
        while (line != '%%EOF' && line != null) {
            while (line != '%AI5_BeginLayer' && line != '%%EOF') {
                line = file.readln();
            }
            if (line == '%AI5_BeginLayer') {
                automode = false;
            }
            while (line != '%AI5_EndLayer--' && line != '%%EOF') {
                line = file.readln();
                var data = line.split(/ /);
                var xholder, zholder;
                var regRes = line.match(regExp);
                //
                if (regRes) {
                    if (regRes[1] == scaleLayerName) {
                        automode = true;
                        xholder = undefined;
                        zholder = undefined;
                        print("autoscale for layer: "+name);
                    } else {
                        automode = false;
                    }
                } else if (data.length == 3 && data[2].localeCompare("m") == 0) {
                   xholder = 1 * parseFloat(data[0]);
                   zholder = -1 * parseFloat(data[1]);
                } else if (data.length == 3 && (data[2].localeCompare("l") == 0 || data[2].localeCompare("L") == 0)) { 
                   xholder = 1 * parseFloat(data[0]);
                   zholder = -1 * parseFloat(data[1]);
                } else if (data.length == 5 && (data[4].localeCompare("v") == 0 || data[4].localeCompare("V") == 0)) { 
                   xholder = 1 * parseFloat(data[2]);
                   zholder = -1 * parseFloat(data[3]);
                } else if (data.length == 5 && (data[4].localeCompare("y") == 0 || data[4].localeCompare("Y") == 0)) { 
                   xholder = 1 * parseFloat(data[2]);
                   zholder = -1 * parseFloat(data[3]);
                } else if (data.length == 7 && (data[6].localeCompare("c") == 0 || data[6].localeCompare("C") == 0)) { 
                   xholder = 1 * parseFloat(data[4]);
                   zholder = -1 * parseFloat(data[5]);
                }
                //
                if (xholder != undefined && aminX == undefined && automode) {
                       aminX = xholder;
                       amaxX = xholder;       
                }
                if (zholder != undefined && aminZ == undefined && automode) {
                       aminZ = zholder;
                       amaxZ = zholder;       
                }
                if (automode && xholder && zholder) {
                   aminX = Math.min(aminX, xholder);
                   amaxX = Math.max(amaxX, xholder);
                   aminZ = Math.min(aminZ, zholder);
                   amaxZ = Math.max(amaxZ, zholder);
                }
                //
            }
        }
        var xDist = Math.sqrt(Math.pow(amaxX - aminX, 2));
        var zDist = Math.sqrt(Math.pow(amaxZ - aminZ, 2));
        var scaleDist = (xDist >= zDist)? xDist : zDist;
        if (xDist >= zDist) {
            print("*x cache:"+amaxX+","+aminX);
            print("z cache:"+amaxZ+","+aminZ);
        } else {
            print("*z cache:"+amaxZ+","+aminZ);
            print("x cache:"+amaxX+","+aminX);
        }
        if (scaleDist) {
            print(scaleDist);
            scale = 1 / scaleDist;
            print(scale);
            tool.setParameter("scale",scale);
            tool.update();
        } else {
            print("No Layer named 'scale' is detected.");
        }
        // reopen
        file.seek(0,SEEK_SET);
        line = file.readln();
    }
    
    if (makeCenter) {
        var minX = undefined;
        var minZ = undefined;
        var maxX = undefined;
        var maxZ = undefined;
        var distX = 0;
        var distZ = 0;
        xholder = undefined;
        zholder = undefined;
        
        while (line != '%%EOF' && line != null) {
            while (line != '%AI5_BeginLayer' && line != '%%EOF') {
                line = file.readln();
            }
            while (line != '%AI5_EndLayer--' && line != '%%EOF') {
                line = file.readln();
                var data = line.split(/ /);
                var xholder, zholder;
                if (data.length == 3 && data[2].localeCompare("m") == 0) {
                   xholder = scale * parseFloat(data[0]);
                   zholder = -scale * parseFloat(data[1]);
                } else if (data.length == 3 && (data[2].localeCompare("l") == 0 || data[2].localeCompare("L") == 0)) { 
                   xholder = scale * parseFloat(data[0]);
                   zholder = -scale * parseFloat(data[1]);
                } else if (data.length == 5 && (data[4].localeCompare("v") == 0 || data[4].localeCompare("V") == 0)) { 
                   xholder = scale * parseFloat(data[2]);
                   zholder = -scale * parseFloat(data[3]);
                } else if (data.length == 5 && (data[4].localeCompare("y") == 0 || data[4].localeCompare("Y") == 0)) { 
                   xholder = scale * parseFloat(data[2]);
                   zholder = -scale * parseFloat(data[3]);
                } else if (data.length == 7 && (data[6].localeCompare("c") == 0 || data[6].localeCompare("C") == 0)) { 
                   xholder = scale * parseFloat(data[4]);
                   zholder = -scale * parseFloat(data[5]);
                }
                if (xholder != undefined && minX == undefined) {
                    minX = xholder;
                    maxX = xholder;
                }
                if (zholder != undefined && minZ == undefined) {
                    minZ = zholder;
                    maxZ = zholder;
                }
                minX = (minX > xholder)? xholder : minX;
                minZ = (minZ > zholder)? zholder : minZ;
                maxX = (maxX < xholder)? xholder : maxX;
                maxZ = (maxZ < zholder)? zholder : maxZ;
            }
        }
        distX = Math.sqrt(Math.pow(maxX - minX, 2));
        distZ = Math.sqrt(Math.pow(maxZ - minZ, 2));
        print('distX:'+distX+',distZ:'+distZ);
        move = setValueForPlane(basePlane, move, -1*(Math.abs(minX)+distX/2), Math.abs(minZ) + distZ / -2);
        file.seek(0,SEEK_SET);
        line = file.readln();
    }
    
    while (line != '%%EOF' && line != null) {
        while (line != '%AI5_BeginLayer' && line != '%%EOF') {
            line = file.readln();
        }
        
        if (line == '%AI5_BeginLayer') {
            if (splineobj) {
                 splineobj.update();
                 splineobj.setParameter("position",move);
            }
            splineobj = doc.addObject(SPLINE);
            spline = splineobj.core();
        } else {
            break;
        }
        while (line != '%AI5_EndLayer--' && line != '%%EOF') {
            line = file.readln();
            var data = line.split(/ /);
            var regRes = line.match(regExp);
            //
            if (regRes) {
                var name = regRes[1];
                if (!name) name = 'Undefined';
                
                splineobj.setParameter("name",name);
                //print("layer:"+name);
            } else if (data.length == 3 && data[2].localeCompare("m") == 0) {
                var p1    = scale * parseFloat(data[0]);
                var p2    = -scale * parseFloat(data[1]);
                to = setValueForPlane(basePlane,to,p1,p2);
                spline.move(to);
                hitcount++;
                //print("line move");
            } else if (data.length == 3 && (data[2].localeCompare("l") == 0 || data[2].localeCompare("L") == 0)) { 
                var p1    = scale * parseFloat(data[0]);
                var p2    = -scale * parseFloat(data[1]);
                to = setValueForPlane(basePlane,to,p1,p2);
                spline.line(to);
                hitcount++;
            } else if (data.length == 5 && (data[4].localeCompare("v") == 0 || data[4].localeCompare("V") == 0)) { 
                c1 = scale * parseFloat(data[0]);
                c2 = -scale * parseFloat(data[1]);
                p1 = scale * parseFloat(data[2]);
                p2 = -scale * parseFloat(data[3]);
                cont2 = setValueForPlane(basePlane,cont2,c1,c2);
                to = setValueForPlane(basePlane,to,p1,p2);
                spline.curve(spline.currentPoint(),cont2,to);
                hitcount++;
            } else if (data.length == 5 && (data[4].localeCompare("y") == 0 || data[4].localeCompare("Y") == 0)) { 
                c1 = scale * parseFloat(data[0]);
                c2 = -scale * parseFloat(data[1]);
                d1 = p1 = scale * parseFloat(data[2]);
                d2 = p2 = -scale * parseFloat(data[3]);
                cont1 = setValueForPlane(basePlane,cont1,c1,c2);
                cont2 = setValueForPlane(basePlane,cont2,d1,d2);
                to = setValueForPlane(basePlane,to,p1,p2);
                spline.curve(cont1,cont2,to);
                hitcount++;
            } else if (data.length == 7 && (data[6].localeCompare("c") == 0 || data[6].localeCompare("C") == 0)) { 
                c1 = scale * parseFloat(data[0]);
                c2 = -scale * parseFloat(data[1]);
                d1 = scale * parseFloat(data[2]);
                d2 = -scale * parseFloat(data[3]);
                p1 = scale * parseFloat(data[4]);
                p2 = -scale * parseFloat(data[5]);
                cont1 = setValueForPlane(basePlane,cont1,c1,c2);
                cont2 = setValueForPlane(basePlane,cont2,d1,d2);
                to = setValueForPlane(basePlane,to,p1,p2);
                spline.curve(cont1,cont2,to);
                hitcount++;
            } else if (data.length == 1) {
                if (data[0].localeCompare("f") == 0 || data[0].localeCompare("s") == 0 || data[0].localeCompare("b") == 0) { 
                    //spline.close();
                }
            }
        }
    }
    
    if (splineobj) {
        splineobj.setParameter("position",move);
        splineobj.update();
    }
    file.close();

    if (hitcount == 0) {
        OS.messageBox("Adobe Illustrator Import","No path data could be imported. Please ensure the .ai file is saved without any compression.");
    }
}
